<?php

use Devmonsta\Libs\Posts;

class Post extends Posts
{

    public function register_controls()
    {

        $this->add_box([
            'id'        => 'post_box_1',
            'post_type' => 'post',
            'title'     => 'Posts Settings',
        ]);

        /**
         * control for text input
         */

        $this->add_control( [
            'type'         => 'switcher',
            'box_id' => 'post_box_1',
            'name'         => 'post_details_layout_overwrite',
            'value'        => 'no',
            'label'        => esc_html__( 'Overwrite Layout', 'qoxag' ),
            'desc'         => esc_html__( 'It will orvewrite the customize settings single post layout', 'qoxag' ),
            'left-choice'  => [
                'no' => esc_html__( 'No', 'qoxag' ),
            ],
            'right-choice' => [
                'yes' => esc_html__( 'Yes', 'qoxag' ),
            ],
        ] );

        $this->add_control( [
            'name'    => 'qoxag_blog_details_layout',
            'box_id' => 'post_box_1',
            'type'    => 'image-picker',
            'value'   => 'style1',
            'attr'    => [
                'class'    => 'custom-class',
                'data-foo' => 'bar',
            ],
            'label'   => esc_html__( 'Post Header Layout', 'qoxag' ),
            'desc'    => esc_html__( 'Select single post header layout', 'qoxag' ),
            'choices' => [
                'style1' => [
                    'small' => get_template_directory_uri() . '/assets/images/admin/post-header/min-style1.png',
                    'large' => get_template_directory_uri() . '/assets/images/admin/post-header/min-style1.png',
                ],
                'style2' => [
                    'small' => get_template_directory_uri() . '/assets/images/admin/post-header/min-style1.png',
                    'large' => get_template_directory_uri() . '/assets/images/admin/post-header/min-style1.png',
                ],
                'style3' => [
                    'small' => get_template_directory_uri() . '/assets/images/admin/post-header/min-style2.png',
                    'large' => get_template_directory_uri() . '/assets/images/admin/post-header/min-style2.png',
                ],
                'style4' => [
                    'small' => get_template_directory_uri() . '/assets/images/admin/post-header/min-style2.png',
                    'large' => get_template_directory_uri() . '/assets/images/admin/post-header/min-style2.png',
                ],
            ],
            'conditions' => [
                [
                    'control_name' => 'post_details_layout_overwrite',
                    'operator'     => '==',
                    'value'        => 'yes',
                ],
            ],
        ] );

        $this->add_control([
            'box_id' => 'post_box_1',
            'type'   => 'url',
            'name'   => 'featured_video',
            'label'     => esc_html__('Video URL', 'qoxag'),
            'desc'     => esc_html__('Paste a video link from Youtube, Vimeo, Dailymotion, Facebook or Twitter it will be embedded in the post and the thumb used as the featured image of this post. You need to choose "Video Format" as post format to use "Featured Video".', 'qoxag'),
        ]);

        $this->add_control( [
            'box_id' => 'post_box_1',
            'type'   => 'url',
            'name'   => 'format_audio_url',
            'value'  => '',
            'desc'   => esc_html__('Enter your audio URL', 'qoxag'),
            'label'  => esc_html__( 'Audio URL(Only for audio format)', 'qoxag' ),
        ] );

        $this->add_control([
            'box_id' => 'post_box_1',
            'type'   => 'text',
            'name'   => 'format_quote_title',
            'label'     => esc_html__('Quote title(Only for quote format)', 'qoxag'),
        ]);

        $this->add_control( [
            'box_id' => 'post_box_1',
            'type'   => 'text',
            'name'   => 'format_quote_author',
            'value'  => '',
            'desc'   => esc_html__('Enter quote author name', 'qoxag'),
            'label'  => esc_html__( 'Quote author name(Only for quote format)', 'qoxag' ),
        ] );

        $this->add_control([
            'box_id' => 'post_box_1',
            'type'   => 'text',
            'name'   => 'format_quote_designation',
            'label'     => esc_html__('Quote author designation(Only for quote format)', 'qoxag'),
        ]);

        $this->add_control( [
            'box_id' => 'post_box_1',
            'type'   => 'url',
            'name'   => 'format_quote_website_url',
            'value'  => '',
            'desc'   => esc_html__('Enter quote website url', 'qoxag'),
            'label'  => esc_html__( 'Quote website URL(Only for quote format)', 'qoxag' ),
        ] );

        $this->add_control( [
            'box_id' => 'post_box_1',
            'type'   => 'text',
            'name'   => 'format_gallery_images',
            'value'  => '',
            'desc'   => esc_html__('Gallery images', 'qoxag'),
            'label'  => esc_html__( 'Add gallery image(Only for gallery format)', 'qoxag' ),
        ] );

        $this->add_control( [
            'box_id'   => 'post_box_1',
            'type'     => 'repeater',
            'name'     => 'format_gallery_all_images',
            'label'    => esc_html__('Gallery images', 'qoxag'),
            'add_new'  => esc_html__('Add gallery image', 'qoxag'),
            'controls' => [                
                [
                    'box_id'   => 'post_box_2',
                    'name'     => 'upload_image_repeater',
                    'type'     => 'upload',
                    'label'    => esc_html__('Upload a image', 'qoxag'),
                    'desc'     => esc_html__('Single image', 'qoxag'),
                    'multiple' => true,
                ], 
   
            ],
        ] );

        $this->add_control( [
            'box_id' => 'post_box_1',
            'type'   => 'textarea',
            'name'   => 'single_post_ads',
            'value'  => '',
            'desc'   => esc_html__('Paste the code of ads', 'qoxag'),
            'label'  => esc_html__( 'Post ads', 'qoxag' ),
        ] );

        // recipe post settings 
        
        $this->add_box([
            'id'        => 'post_box_2',
            'post_type' => 'post',
            'title'     => 'Recipe Settings',
        ]);

        $this->add_control( [
            'type'         => 'switcher',
            'box_id'       => 'post_box_2',
            'name'         => 'recipe_switch',
            'value'        => 'no',
            'label'        => esc_html__( 'Recipe Enable', 'qoxag' ),
            'desc'         => esc_html__( 'It will show recipe meta in single post', 'qoxag' ),
            'left-choice'  => [
                'no' => esc_html__( 'No', 'qoxag' ),
            ],
            'right-choice' => [
                'yes' => esc_html__( 'Yes', 'qoxag' ),
            ],
        ] );

        $this->add_control([
            'box_id' => 'post_box_2',
            'type'   => 'text',
            'name'   => 'prep_time',
            'label'     => esc_html__('Prep time:', 'qoxag'),
            'conditions' => [
                [
                    'control_name' => 'recipe_switch',
                    'operator'     => '==',
                    'value'        => 'yes',
                ],
            ],
        ]);
        $this->add_control([
            'box_id' => 'post_box_2',
            'type'   => 'text',
            'name'   => 'cook_time',
            'label'     => esc_html__('Cook Time:', 'qoxag'),
            'conditions' => [
                [
                    'control_name' => 'recipe_switch',
                    'operator'     => '==',
                    'value'        => 'yes',
                ],
            ],
        ]);
        $this->add_control([
            'box_id' => 'post_box_2',
            'type'   => 'text',
            'name'   => 'total_time',
            'label'     => esc_html__('Total Time:', 'qoxag'),
            'conditions' => [
                [
                    'control_name' => 'recipe_switch',
                    'operator'     => '==',
                    'value'        => 'yes',
                ],
            ],
        ]);
        $this->add_control([
            'box_id' => 'post_box_2',
            'type'   => 'text',
            'name'   => 'serving_time',
            'label'     => esc_html__('Servings:', 'qoxag'),
            'conditions' => [
                [
                    'control_name' => 'recipe_switch',
                    'operator'     => '==',
                    'value'        => 'yes',
                ],
            ],
        ]);

    }
}
